<?php $title="Grid system demo" ?>
<?php include("#top.htm");?>




<!-- intro -->
<section id="content" class="container_12 clearfix">

	<div id="grid-demo-intro" class="grid_8">

		<hgroup>
			<h1>Grid system demo</h1>
			<h2>Create any layout you want easily</h2>
		</hgroup>
		
		<p>
			This page demonstrates various possible layouts with the grid system included with the theme.
			Although based on a <a href="http://960.gs">960</a> grid system idea (12 columns), it has some improvements
			for achieving flexibility and productivity. For example:
		</p>
			<ul class="blue">
				<li>Subcontainer classes for <b>nesting the grid columns</b></li>
				<li>Uses <b>960.gs</b> class naming convention</li>
				<li>Forget about classes like <em>'last'</em> or <em>'first'</em> to mark appropriate columns, focus here is simplicity and flexibility: you don't need them</li>
				<li><b>Only 4Kb</b>, uncompressed</li>
			</ul>
		<p>
			For 960.gs users, learning curve doesn't exist - the
			grid system already uses class naming convention already established with 960.gs.
			Have a look and explore some examples of the grid layout (<b>hover mouse over the column to see the content width</b>):
		</p>
	</div>

	<!-- sidebar -->
	<aside class="grid_4">
		Sidebar example
	</aside>
	<!-- / sidebar -->

</section>
<!-- / intro -->

<section id="grid-demo" class="container_12 clearfix">
	<div class="grid_4">*</div>
	<div class="grid_4">*</div>
	<div class="grid_4">*</div><div class="grid_4">*</div><div class="grid_4">*</div><div class="grid_4">*</div><div class="grid_4">*</div>
	<div class="grid_4">*</div>
	<div class="grid_4">*</div><div class="grid_4">*</div><div class="grid_4">*</div><div class="grid_4">*</div>
</section>
<!-- demo page for the grid system -->
<div id="grid-demo" class="container_12 clearfix">

<h6>Full width</h6>
<div class="grid_12">
	<p>Full width column</p>
</div>

<h6>2 columns</h6>
<div class="grid_6">
	<p>First column</p>
</div>
<div class="grid_6">
	<p>Second column</p>
</div>
<div class="clear"></div>

<h6>3 columns</h6>
<div class="grid_4">
	<p>First column</p>
</div>
<div class="grid_4">
	<p>Second column</p>
</div>
<div class="grid_4">
	<p>Third column</p>
</div>
<div class="clear"></div>

<h6>4 columns</h6>
	<div class="grid_3">
<p>First column</p>
</div>
<div class="grid_3">
	<p>Second column</p>
</div>
<div class="grid_3">
	<p>Third column</p>
</div>
<div class="grid_3">
	<p>Fourth column</p>
</div>
<div class="clear"></div>

<h6>asymetric</h6>
<div class="grid_2">
	<p>First column</p>
</div>
<div class="grid_10">
	<p>Second column</p>
</div>
<div class="clear"></div>

<div class="grid_4">
	<p>Third column</p>
</div>
<div class="grid_8">
	<p>Fourth column</p>
</div>
<div class="clear"></div>

<div class="grid_5">
	<p>Fifth column</p>
</div>
<div class="grid_7">
	<p>Sixth column</p>
</div>
<div class="clear"></div>


<h6>Subcontainers (nesting)</h6>
<div class="container_6">
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
<div class="clear"></div>
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
<div class="clear"></div>
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
</div>

<div class="grid_6">
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
</div>

<div class="clear"></div>

<div class="container_9">
	<div class="grid_6">
		<p>First column</p>
	</div>
	<div class="grid_3">
		<p>Second column</p>
	</div>

	<div class="container_6">
		<div class="grid_3">
			<p>demo column</p>
		</div>
		<div class="grid_3">
			<p>demo column</p>
		</div>
		<div class="grid_3">
			<p>demo column</p>
		</div>
		<div class="grid_3">
			<p>demo column</p>
		</div>
		<div class="grid_3">
			<p>demo column</p>
		</div>
		<div class="grid_3">
			<p>demo column</p>
		</div>
	</div>
	<div class="grid_3">
		<p>Another column</p>
		<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
		<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
		<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	</div>
</div>
<div class="grid_3">
	<p>Sidebar column</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
</div>
<div class="clear"></div>

<div class="clear"></div>

<div class="grid_8">
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
</div>
<div class="container_4">
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
	<div class="clear"></div>
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
</div>
<div class="clear"></div>

<div class="clear"></div>

<div class="grid_4">
<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
</div>
<div class="container_8">
	<div class="grid_4">
		<p>First column</p>
	</div>
	<div class="grid_4">
		<p>Second column</p>
	</div>
	<div class="clear"></div>
	<div class="grid_4">
		<p>First column</p>
	</div>
	<div class="grid_4">
		<p>Second column</p>
	</div>
</div>
<div class="clear"></div>

<div class="clear"></div>

<div class="container_4">
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
	<div class="clear"></div>
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
</div>
<div class="grid_4">
	<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>
</div>
<div class="container_4">
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
	<div class="clear"></div>
	<div class="grid_2">
		<p>First column</p>
	</div>
	<div class="grid_2">
		<p>Second column</p>
	</div>
</div>
<div class="clear"></div>

</div>


<!-- grid demo styles -->
<style type="text/css" media="screen,all">
#grid-demo div div {
	background-color:#ddd;
}

#grid-demo div div div {
	background-color:#ccc;
}

#grid-demo h6 {
	color: #ea6b48;
}

#grid-demo .grid_1 p {
	outline:1px solid #888;
	margin-bottom:0;
	overflow:hidden;
}

aside .info,
#grid-demo div .info {
	height:100%;
	width:100%;
	margin: 4px 0 2px;
	text-align: center;
	font-size: 11px;
	font-family: "Courier New", Courier, monospace;
	background-color:#ccc;
}

.hover {
	outline:1px solid orange;
}

div.clear {
	height: 9px;
	margin:0;
	padding:0;
}
</style>
<!-- / grid demo styles -->

<?php include("#bottom.htm"); ?>

<script>
// grid demo script: add classes and ID's to the grids for better visualisation
$(function () {
	$('#grid-demo div, aside').not('#grid-demo-intro').each(function(){
		var w=$(this).width();
		var text='<p class="info">&lt;div class="<strong>' + $(this).attr('class') + '"&gt;</strong></p>';
		$(this)
			.append(text)
			.attr('title', 'Content:' + w + 'px width')
			.hover(function(){
				$(this).addClass('hover');
			},function(){
				$(this).removeClass('hover');
			});
	});
});
</script>